unit Unit1;

//   ,     
//      .   
//     Image.
// :   EllipseDirect,  
//   .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Panel1: TPanel;
    Image1: TImage;
    Panel2: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    CbBoxFigure: TComboBox;
    StTxtBColor: TStaticText;
    StTxtPColor: TStaticText;
    CbBoxBStyle: TComboBox;
    CbBoxHL: TComboBox;
    CbBoxWL: TComboBox;
    ColorDialog1: TColorDialog;
    BttClear: TButton;

    procedure StTxtBColorClick(Sender: TObject);
    procedure StTxtPColorClick(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure BttClearClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

var
    bColor : TColor;   //  
    pColor : TColor;   //  
var HL     : integer;  //    
    WL     : integer;  //    

//    
procedure EllipseDirect (RqCnv : TCanvas; XB,YB,XE,YE : integer);
var BArr : array [0..3] of Tpoint;
begin
   //    
   BArr[0].X := XB;
   BArr[0].Y := YB + ((YE - YB) div 2);
   BArr[1].X := XB;
   BArr[1].Y := YB + Trunc((YE - YB) / 4.5);
   BArr[2].X := XB + Trunc((XE - XB) / 4.5);
   BArr[2].Y := YB;
   BArr[3].X := XB + ((XE - XB) div 2);
   BArr[3].Y := YB;
   RqCnv.PolyBezier(BArr);
   //    
   BArr[0].X := XB;
   BArr[0].Y := YB + ((YE - YB) div 2);
   BArr[1].X := XB;
   BArr[1].Y := YE - Trunc((YE - YB) / 4.5);
   BArr[2].X := XB + Trunc((XE - XB) / 4.5);
   BArr[2].Y := YE;
   BArr[3].X := XB + ((XE - XB) div 2);
   BArr[3].Y := YE;
   RqCnv.PolyBezier(BArr);
   //    
   BArr[0].X := XB + ((XE - XB) div 2);
   BArr[0].Y := YB;
   BArr[1].X := XE - Trunc((XE - XB) / 4.5);
   BArr[1].Y := YB;
   BArr[2].X := XE;
   BArr[2].Y := YB + Trunc((YE - YB) / 4.5);
   BArr[3].X := XE;
   BArr[3].Y := YB + ((YE - YB) div 2);
   RqCnv.PolyBezier(BArr);
   //    
   BArr[0].X := XE;
   BArr[0].Y := YB + ((YE - YB) div 2);
   BArr[1].X := XE;
   BArr[1].Y := YE - Trunc((YE - YB) / 4.5);
   BArr[2].X := XE - Trunc((XE - XB) / 4.5);
   BArr[2].Y := YE;
   BArr[3].X := XB + ((XE - XB) div 2);
   BArr[3].Y := YE;
   RqCnv.PolyBezier(BArr);
end;

//  ,   
procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  with Image1.Canvas do
  begin
    //     Color  Width
    Pen.Style   := psSolid;
    Pen.Color   := pColor;
    Pen.Width   := 1;

    //     Color  Style
    Brush.Color := bColor;
    case CbBoxBStyle.ItemIndex of
    0 : Brush.Style := bsClear;
    1 : Brush.Style := bsSolid;
    2 : Brush.Style := bsHorizontal;
    3 : Brush.Style := bsVertical;
    4 : Brush.Style := bsCross;
    5 : Brush.Style := bsBDiagonal;
    6 : Brush.Style := bsFDiagonal;
    7 : Brush.Style := bsDiagCross;
    end;

    //    HL  WL
    if CbBoxHL.ItemIndex >= 0 then
    HL := StrToInt(CbBoxHL.Items[CbBoxHL.ItemIndex]);
    if CbBoxWL.ItemIndex >= 0 then
    WL := StrToInt(CbBoxWL.Items[CbBoxWL.ItemIndex]);

    //   Rectangle, RoundRect, Ellipse
    case CbBoxFigure.ItemIndex of
    0 : Rectangle(X, Y, X + WL, Y + HL);
    1 : RoundRect(X, Y, X + WL, Y + HL, WL div 3, HL div 3);
    2 : Ellipse(X, Y, X + WL, Y + HL);
    3 : EllipseDirect (Image1.Canvas, X, Y, X + WL, Y + HL);
    end;

  end; // of with Image1.Canvas
end;

//    Image
procedure ClearImage(RqImg : TImage);
begin
  with RqImg.Canvas do
  begin
     //      
     Brush.Color := RqImg.Parent.Brush.Color;
     Brush.Style := bsSolid;
     // 
     FillRect(Rect(0,0,RqImg.Width,RqImg.Height));
  end; // of with RqImg.Canvas
end;

//   Image
procedure TForm1.BttClearClick(Sender: TObject);
begin
   ClearImage(Image1);
end;

//    
procedure TForm1.StTxtBColorClick(Sender: TObject);
begin
  if ColorDialog1.Execute
  then begin
    bColor := ColorDialog1.Color;   //  
    StTxtBColor.Color := bColor;
  end;
end;

//    
procedure TForm1.StTxtPColorClick(Sender: TObject);
begin
  if ColorDialog1.Execute
  then begin
    pColor := ColorDialog1.Color;   //  
    StTxtPColor.Color := pColor;
  end;
end;

//   
procedure TForm1.FormCreate(Sender: TObject);
begin
  HL := 40;               //    
  WL := 40;               //    
  bColor := clSkyBlue;    //  
  pColor := clNavy;       //  
  StTxtBColor.Color := bColor;
  StTxtPColor.Color := pColor;
  ClearImage(Image1);
end;

end.
